/*
 * Decompiled with CFR 0.152.
 */
package fr.vartax.vartacraft;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class VartacraftBootstrap
extends JFrame {
    private static final String LAUNCHER_URL = "http://vartacraft.ouiweb.eu/update/launcher.jar";
    private static final File DATA_DIR = new File(System.getProperty("user.home"), "AppData/Roaming/.vartacraft");
    private static final File LAUNCHER_FILE = new File(DATA_DIR, "launcher.jar");
    private final Color BG_COLOR = new Color(25, 25, 25);
    private final Color ACCENT_COLOR = new Color(0, 150, 255);
    private final Color TEXT_COLOR = new Color(230, 230, 230);
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel iconLabel;

    public VartacraftBootstrap() {
        this.setUndecorated(true);
        this.setSize(500, 250);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setBackground(new Color(0, 0, 0, 0));
        this.loadWindowIcon();
        JPanel contentPane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(VartacraftBootstrap.this.BG_COLOR);
                g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
            }
        };
        contentPane.setOpaque(false);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(new EmptyBorder(20, 30, 20, 30));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setOpaque(false);
        this.iconLabel = new JLabel();
        this.iconLabel.setAlignmentX(0.5f);
        this.loadIcon();
        JLabel titleLabel = new JLabel("VARTACRAFT");
        titleLabel.setFont(new Font("Segoe UI", 1, 28));
        titleLabel.setForeground(this.ACCENT_COLOR);
        titleLabel.setAlignmentX(0.5f);
        topPanel.add(this.iconLabel);
        topPanel.add(Box.createVerticalStrut(10));
        topPanel.add(titleLabel);
        this.statusLabel = new JLabel("Initialisation...");
        this.statusLabel.setFont(new Font("Segoe UI", 2, 14));
        this.statusLabel.setForeground(this.TEXT_COLOR);
        this.statusLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setUI(new BasicProgressBarUI(){

            @Override
            protected void paintDeterminate(Graphics g, JComponent c) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getAmountFull(this.progressBar.getInsets(), this.progressBar.getWidth(), this.progressBar.getHeight()) * 1;
                g2d.setColor(new Color(45, 45, 45));
                g2d.fillRoundRect(0, 0, this.progressBar.getWidth(), 8, 8, 8);
                g2d.setColor(VartacraftBootstrap.this.ACCENT_COLOR);
                g2d.fillRoundRect(0, 0, width, 8, 8, 8);
            }
        });
        this.progressBar.setPreferredSize(new Dimension(400, 8));
        this.progressBar.setBorder(null);
        JPanel centerPanel = new JPanel(new GridLayout(2, 1, 0, 10));
        centerPanel.setOpaque(false);
        centerPanel.add(topPanel);
        centerPanel.add(this.statusLabel);
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)this.progressBar, "South");
        this.setContentPane(contentPane);
    }

    private void loadIcon() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/icon.png");
            if (is != null) {
                BufferedImage img = ImageIO.read(is);
                this.iconLabel.setIcon(new ImageIcon(img.getScaledInstance(64, 64, 4)));
                is.close();
            } else {
                this.iconLabel.setText("\ud83c\udfae");
                this.iconLabel.setFont(new Font("Segoe UI Emoji", 0, 48));
                this.iconLabel.setForeground(this.ACCENT_COLOR);
            }
        }
        catch (Exception e) {
            this.iconLabel.setText("\ud83c\udfae");
        }
    }

    private void loadWindowIcon() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/icon.png");
            if (is != null) {
                this.setIconImage(ImageIO.read(is));
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        if (!DATA_DIR.exists()) {
            DATA_DIR.mkdirs();
        }
        VartacraftBootstrap frame = new VartacraftBootstrap();
        frame.setVisible(true);
        new Thread(() -> {
            try {
                frame.runUpdateCycle();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(frame, "Erreur : " + e.getMessage(), "Erreur", 0);
                System.exit(1);
            }
        }).start();
    }

    private void runUpdateCycle() throws Exception {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalMemoryMB = osBean.getTotalPhysicalMemorySize() / 0x100000L;
        if (totalMemoryMB < 1800L) {
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(this, "<html><body style='width: 250px; font-family: Segoe UI;'><h2 style='color: #ff3333;'>RAM Insuffisante</h2>Vartacraft requiert au moins 2 Go de RAM.<br>Votre PC : <b>" + String.format("%.2f", (double)totalMemoryMB / 1024.0) + " Go</b>.</body></html>", "Erreur", 0);
                System.exit(0);
            });
            return;
        }
        this.setStatus("V\u00e9rification des mises \u00e0 jour...");
        this.downloadFile(LAUNCHER_URL, LAUNCHER_FILE);
        this.setStatus("D\u00e9marrage du Launcher...");
        String xmx = totalMemoryMB > 16000L ? "-Xmx8G" : (totalMemoryMB < 4500L ? "-Xmx1500M" : "-Xmx4G");
        String xms = totalMemoryMB < 4500L ? "-Xms512M" : "-Xms2G";
        ProcessBuilder pb = new ProcessBuilder("java", xmx, xms, "-jar", LAUNCHER_FILE.getAbsolutePath());
        pb.directory(DATA_DIR);
        pb.start();
        Thread.sleep(1000L);
        System.exit(0);
    }

    private void setStatus(String text) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(text));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadFile(String urlStr, File dest) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "VartacraftBootstrap/1.0");
        long size = conn.getContentLengthLong();
        Throwable throwable = null;
        Object var8_8 = null;
        try {
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            try {
                try (FileOutputStream out = new FileOutputStream(dest);){
                    int read;
                    byte[] buffer = new byte[8192];
                    long total = 0L;
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                        total += (long)read;
                        if (size <= 0L) continue;
                        int percent = (int)((double)total / (double)size * 100.0);
                        SwingUtilities.invokeLater(() -> this.progressBar.setValue(percent));
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

